# Usage: sh experiments.sh

python generate_matrices.py --dataset=mnist --epochs=6  --hidden_neurons=128
python generate_matrices.py --dataset=fashion_mnist --epochs=6  --hidden_neurons=128
python generate_matrices.py --dataset=smallnorb --epochs=50  --hidden_neurons=1024
python generate_matrices.py --dataset=colorectal_histology --epochs=50  --hidden_neurons=1024


python disp_experiments.py --input_dir=experiments
python plot_em_experiment.py --output_file=experiments/em_experiment.pdf

for DS in mnist fashion_mnist smallnorb colorectal_histology
# for DS in colorectal_histology
do
echo $DS
  python plot_spectrum.py \
    --input_file="matrices/$DS/fisher.npy"  \
    --output_file="matrices/$DS/spectrum.pdf" \
    --title="Singular values for $DS"
  python plot_weights.py \
    --input_file="matrices/$DS/fisher.npy"  \
    --output_file="matrices/$DS/fisher.pdf"
  python weighted_lra.py \
    --fisher_file="matrices/$DS/fisher.npy" \
    --weight_file="matrices/$DS/weight.npy" \
    --output_file="experiments/$DS.json" \
    --trials=5 \
    --rank=20
done

for METRIC in loss time
do
python plot_experiments.py \
  --input_dir=experiments \
  --output_file="experiments/$METRIC.pdf" \
  --metric="$METRIC"
done
